/*
 
***************************************************************************
Macro_Scripts File
Author:   Adam Felt
Macro_Scripts that implement some animation specific methods

Revision History
    May 26, 2004 - Adam Felt - Created
    December 14, 2004 - Nicolas Lonard - added ToggleLimits
	
-- MODIFY THIS AT YOUR OWN RISK
***************************************************************************

*/

macroScript DeleteSelectedAnimation
buttontext:~BUTTONTEXT_CAPTION~
category:~CATEGORY_ANIMATION_TOOLS~ 
internalCategory:"Animation Tools" 
tooltip:~DEL_SELECTED_ANIM_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	
	On Execute Do
	(
		maxOps.deleteSelectedAnimation()
	)
)

macroScript OpenReactionManager
	buttontext:~BUTTONTEXT_REACTION_MANAGER~
	category:~OPENREACTIONMANAGER_CATEGORY_ANIM_TOOLS~
	internalCategory:"Animation Tools" 
	toolTip:~OPENREACTIONMANAGER_TOOLTIP~
(
	reactionMgr.openEditor()
)

macroScript OpenAnimationLayers
	buttontext:~BUTTONTEXT_ANIM_LAYERS~
	category:~OPENANIMATIONLAYERS_ANIM_TOOLS~
	internalCategory:"Animation Tools" 
	toolTip:~OPENANIMATIONLAYERS_TOOLTIP~
(
	animLayerManager.showAnimLayersManagerToolbar true	
)

macroScript ToggleLimits
	buttontext:~BUTTONTEXT_TOGGLE_LIMITS~
	category:~TOGGLELIMITS_ANIM_TOOLS~
	internalCategory:"Animation Tools" 
	toolTip:~TOGGLE_LIMITS_TOOLTIP~
(
	Fn toggleAnimLimits anim &limitTab &toggleValue =
	(
		local ILimitControl
		if anim != undefined do
		(
			if (ILimitControl = getInterface anim #limits) != undefined do		
			(
				if toggleValue and anim.IsEnabled() do
				(
					toggleValue = false
				)
				append limitTab anim 
			)
			
			for i = 1 to anim.numsubs do
			(
				toggleAnimLimits (getSubAnim anim i) &limitTab &toggleValue
			) 
		)
	)

	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	On Execute Do
	(
		local limitTab = #()
		local toggleValue = true
		for s in selection do
		(
			toggleAnimLimits s &limitTab &toggleValue
		)
		for limit in limitTab do 
		(
			limit.SetEnabled toggleValue
		)
	)
)

macroScript TrajectoryToggle
buttontext:~BUTTONTEXT_TRAJECTORYTOGGLE~
category:~CATEGORY_TRAJECTORYTOGGLE~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYTOGGLE_TOOLTIP~ 
(
	on isChecked Return
	(
		if(maxOps.trajectoryMode == true) then
			return true
		return false
	)
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	On Execute Do
	(
		if(maxOps.trajectoryMode == true) then
			maxOps.trajectoryMode = false
		else
			maxOps.trajectoryMode = true
	)
)


macroScript TrajectoryKeyModeToggle
buttontext:~BUTTONTTEXT_TRAJECTORYKEYMODETOGGLE~
category:~CATEGORY_TRAJECTORYKEYMODETOGGLE~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYKEYMODETOGGLE_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
		
	On Execute Do
	(
		if(maxOps.trajectoryKeySubMode == true) then
			maxOps.trajectoryKeySubMode = false
		else
			maxOps.trajectoryKeySubMode = true
	)
)

macroScript TrajectoryAddKeyModeToggle
buttontext:~BUTTONTTEXT_TRAJECTORYADDKEYMODETOGGLE~
category:~TRAJECTORYADDKEYMODETOGGLE_ANIM_TOOLS_CATEGORY~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYADDKEYMODETOGGLE_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	
	On Execute Do
	(
		if(maxOps.trajectoryAddKeyMode == true) then
			maxOps.trajectoryAddKeyMode = false
		else
			maxOps.trajectoryAddKeyMode = true
	)
)

macroScript TrajectoryDeleteKey
buttontext:~BUTTONTEXT_TRAJECTORYDELETEKEY~
category:~TRAJECTORYDELETEKEY_CATEGORY~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYDELETEKEY_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	
	On Execute Do
	(
		maxOps.deleteSelectedTrajectoryKey()

	)
)



-- END OF FILE
